<?php

return [
    'name' => 'Products',
    'description' => 'View and update your products settings',
    'create' => 'New product',
    'create_product_type' => [
        'physical' => 'New physical product',
        'digital' => 'New digital product',
    ],
    'edit' => 'Edit product - :name',
    'form' => [
        'name' => 'Name',
        'name_placeholder' => 'Product\'s name (Maximum 120 characters)',
        'description' => 'Description',
        'description_placeholder' => 'Short description for product (Maximum 400 characters)',
        'categories' => 'Categories',
        'content' => 'Content',
        'price' => 'Price',
        'quantity' => 'Quantity',
        'brand' => 'Brand',
        'width' => 'Width',
        'height' => 'Height',
        'weight' => 'Weight',
        'date' => [
            'start' => 'From date',
            'end' => 'To date',
        ],
        'image' => 'Images',
        'collections' => 'Product collections',
        'labels' => 'Labels',
        'price_sale' => 'Price sale',
        'product_type' => [
            'title' => 'Product type',
        ],
        'product' => 'Product',
        'total' => 'Total',
        'sub_total' => 'Subtotal',
        'shipping_fee' => 'Shipping fee',
        'discount' => 'Discount',
        'options' => 'Options',
        'shipping' => [
            'height' => 'Height',
            'length' => 'Length',
            'title' => 'Shipping',
            'weight' => 'Weight',
            'wide' => 'Wide',
        ],
        'barcode' => 'Barcode (ISBN, UPC, GTIN, etc.) ',
        'barcode_placeholder' => 'Enter barcode',
        'cost_per_item' => 'Cost per item',
        'cost_per_item_placeholder' => 'Enter cost per item',
        'cost_per_item_helper' => "Customers won't see this price.",
        'stock' => [
            'allow_order_when_out' => 'Allow customer checkout when this product out of stock',
            'in_stock' => 'In stock',
            'out_stock' => 'Out stock',
            'title' => 'Stock status',
        ],
        'storehouse' => [
            'no_storehouse' => 'No storehouse management',
            'storehouse' => 'With storehouse management',
            'title' => 'Storehouse',
            'quantity' => 'Quantity',
        ],
        'tax' => 'Tax',
        'taxes' => 'Taxes',
        'taxes_helper' => 'The default tax rate is configured in <a href=":url">Settings -> Tax</a>. If no specific tax is selected for this product, the default rate will be applied. To disable tax for this product, remove the default tax rate from the tax settings.',
        'is_default' => 'Is default',
        'action' => 'Action',
        'restock_quantity' => 'Restock quantity',
        'remain' => 'Remain',
        'choose_discount_period' => 'Choose Discount Period',
        'cancel' => 'Cancel',
        'no_results' => 'No results!',
        'value' => 'Value',
        'attribute_name' => 'Attribute name',
        'add_more_attribute' => 'Add more attribute',
        'continue' => 'Continue',
        'add_new_attributes' => 'Add new attributes',
        'add_new_attributes_description' => 'Adding new attributes helps the product to have many options, such as size or color.',
        'create_product_variations' => ':link to create product variations!',
        'tags' => 'Tags',
        'write_some_tags' => 'Write some tags',
        'variation_existed' => 'This variation is existed.',
        'no_attributes_selected' => 'No attributes selected!',
        'added_variation_success' => 'Added variation successfully!',
        'updated_variation_success' => 'Updated variation successfully!',
        'created_all_variation_success' => 'Created all variations successfully!',
        'updated_product_attributes_success' => 'Updated product attributes successfully!',
        'stock_status' => 'Stock status',
        'auto_generate_sku' => 'Auto generate SKU?',
        'featured_image' => 'Featured image (optional)',
        'product_id' => 'Product ID',
        'price_sale_percent_helper' => 'Discount :percent from original price.',
        'minimum_order_quantity' => 'Minimum order quantity',
        'minimum_order_quantity_helper' => 'Minimum quantity to place an order, if the value is 0, there is no limit.',
        'maximum_order_quantity' => 'Maximum order quantity',
        'maximum_order_quantity_helper' => 'Maximum quantity to place an order, if the value is 0, there is no limit.',
        'video' => 'Video',
        'video_file' => 'File',
        'video_url' => 'Or External Video URL',
        'video_url_help' => 'Enter YouTube or Vimeo video URL',
        'enter_video_url' => 'Enter video URL',
        'video_thumbnail' => 'Video thumbnail',
        'video_thumbnail_help' => 'Choose a thumbnail for the video. If not selected, it will be automatically get from the video URL if available.',
        'barcode_existed' => 'This barcode is using by another product. Please enter another barcode.',
        'barcode_helper' => 'Must be unique for each product.',
    ],
    'price' => 'Price',
    'quantity' => 'Quantity',
    'type' => 'Type',
    'image' => 'Thumbnail',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'Variation SKU',
    'brand' => 'Brand',
    'cannot_delete' => 'Product could not be deleted',
    'product_deleted' => 'Product deleted',
    'product_collections' => 'Product collections',
    'products' => 'Products',
    'menu' => 'Products',
    'control' => [
        'button_add_image' => 'Add image',
    ],
    'price_sale' => 'Sale price',
    'price_group_title' => 'Manager product price',
    'store_house_group_title' => 'Manager store house',
    'shipping_group_title' => 'Manager shipping',
    'overview' => 'Overview',
    'attributes' => 'Attributes',
    'product_has_variations' => 'Product has variations',
    'manage_products' => 'Manage products',
    'add_new_product' => 'Add a new product',
    'start_by_adding_new_product' => 'Start by adding new products.',
    'edit_this_product' => 'Edit this product',
    'delete' => 'Delete',
    'related_products' => 'Related products',
    'cross_selling_products' => 'Cross-selling products',
    'up_selling_products' => 'Up-selling products',
    'grouped_products' => 'Grouped products',
    'search_products' => 'Search products',
    'selected_products' => 'Selected products',
    'edit_variation_item' => 'Edit',
    'variations_box_description' => 'Click on "Edit attribute" to add/remove attributes of variation or click on "Add new variation" to add variation.',
    'save_changes' => 'Save changes',
    'continue' => 'Continue',
    'edit_attribute' => 'Edit attribute',
    'select_attribute' => 'Select attribute',
    'add_new_variation' => 'Add new variation',
    'edit_variation' => 'Edit variation',
    'generate_variations' => 'Generate variations',
    'generate_variations_confirmation' => 'Are you sure you want to generate variations for this product?',
    'delete_variation' => 'Delete variation?',
    'delete_variation_confirmation' => 'Are you sure you want to delete this variation? This action cannot be undo.',
    'delete_variations_confirmation' => 'Are you sure you want to delete those variations? This action cannot be undo.',
    'product_create_validate_name_required' => 'Please enter product\'s name',
    'product_create_validate_sale_price_max' => 'The discount must be less than the original price',
    'product_create_validate_cost_per_item_max' => 'The cost per item must be less than the original price',
    'product_create_validate_sale_price_required_if' => 'Must enter a discount when you want to schedule a promotion',
    'product_create_validate_end_date_after' => 'End date must be after start date',
    'product_create_validate_start_date_required_if' => 'Discount start date cannot be left blank when scheduling is selected',
    'product_create_validate_sale_price' => 'Discounts cannot be left blank when scheduling is selected',
    'stock_statuses' => [
        'in_stock' => 'In stock',
        'out_of_stock' => 'Out of stock',
        'on_backorder' => 'On backorder',
    ],
    'stock_status' => 'Stock status',
    'processing' => 'Processing...',
    'delete_selected_variations' => 'Delete selected variations',
    'delete_variations' => 'Delete variations',
    'category' => 'Category',
    'product_price_flash_sale_warning' => 'This product is in flash sale <strong>:name</strong> so its price is <strong>:price</strong>.',
    'product_price_discount_warning' => 'This product is in discount <strong>:name</strong> so its price is <strong>:price</strong>.',
    'product_image' => 'Product image',
    'product_name' => 'Product name',
    'product_link' => 'Product link',
    'types' => [
        'physical' => 'Physical',
        'digital' => 'Digital',
    ],
    'digital_attachments' => [
        'title' => 'Digital attachments',
        'add' => 'Add Attachment',
        'file_name' => 'File name',
        'file_size' => 'File size',
        'unsaved' => 'Unsaved',
        'add_external_link' => 'Add external link',
        'enter_file_name' => 'Enter file name',
        'enter_external_link_download' => 'Enter external link download',
        'enter_file_size' => 'Enter file size',
        'external_link_download' => 'External link download',
        'generate_license_code_after_purchasing_product' => 'Enable license code assignment for this product',
        'notify_attachment_updated' => 'Send an email to customer when attachment is updated',
    ],
    'license_codes' => [
        'title' => 'License Codes',
        'add' => 'Add License Code',
        'back' => 'Back to Product',
        'edit' => 'Edit License Code',
        'generate' => 'Generate Codes',
        'manage_codes' => 'Manage License Codes',
        'management' => 'License Code Management',
        'variation_breadcrumb' => 'Variation: :name',
        'variation_label' => 'Product Variation',
        'variation_specific_note' => 'These license codes are specific to this product variation. Customers who purchase this variation will receive codes from this pool.',
        'main_product_note' => 'This product has variations. Each variation can have its own license codes, or customers can receive codes from this main product pool if the variation has no codes.',
        'code' => 'License Code',
        'codes' => 'License Codes',
        'status' => 'Status',
        'assigned_at' => 'Assigned At',
        'status_available' => 'Available',
        'status_used' => 'Used',
        'statuses' => [
            'available' => 'Available',
            'used' => 'Used',
        ],
        'no_codes' => 'No license codes found. Add some codes or generate them automatically.',
        'no_codes_warning_title' => 'No License Codes Available!',
        'no_codes_warning_message' => 'This product is set to "Pick from List" but has no available license codes. Customers who purchase this product will receive auto-generated codes instead. Please add license codes to ensure proper functionality.',
        'no_codes_auto_generate' => 'This product is set to auto-generate license codes. No manual codes needed.',
        'used_code_no_actions' => 'Used code - no actions available',
        'created_successfully' => 'License code created successfully!',
        'updated_successfully' => 'License code updated successfully!',
        'deleted_successfully' => 'License code deleted successfully!',
        'generated_successfully' => 'Generated :count license codes successfully!',
        'duplicates_skipped' => ':count duplicate codes were skipped.',
        'generation_incomplete' => 'Warning: Could only generate :generated out of :requested requested codes due to duplicate conflicts.',
        'cannot_edit_used_code' => 'Cannot edit a used license code.',
        'cannot_delete_used_code' => 'Cannot delete a used license code.',
        'show_all' => 'Show all',
        'show_less' => 'Show less',
        'more' => 'more',
        'used_codes_hidden' => ':count used license code(s) are hidden. You can view all codes in the License Code Management page.',
        'low_stock_title' => 'Low License Code Stock',
        'low_stock_message' => 'Only :count license codes remaining. Consider adding more codes to avoid running out.',
        'out_of_stock_title' => 'Out of License Codes!',
        'out_of_stock_message' => 'No license codes available. Customers will receive auto-generated codes until you add more.',
        'type' => [
            'title' => 'License Code Assignment Method',
            'auto_generate' => 'Auto Generate (System generates codes automatically)',
            'pick_from_list' => 'Pick from List (Use pre-entered codes)',
            'description' => 'Choose how license codes should be assigned to customers when they purchase this product.',
        ],
        'generate_modal' => [
            'title' => 'Generate License Codes',
            'quantity' => 'Quantity',
            'format' => 'Format',
            'custom_pattern' => 'Custom Pattern',
            'pattern_help' => 'Use # for numbers, A for uppercase letters, a for lowercase letters',
            'generate' => 'Generate',
        ],
        'errors' => [
            'feature_not_enabled' => 'License codes feature is not enabled. Please enable it in Ecommerce Settings > Digital Products.',
            'digital_products_not_enabled' => 'Digital products are not enabled. Please enable digital products support first.',
            'product_not_found' => 'Product not found.',
            'not_digital_product' => 'License codes are only available for digital products. This product is set as a physical product.',
            'license_codes_not_enabled_for_product' => 'License code management is not enabled for this product. Please enable "Generate license code after purchasing product" in the product settings.',
            'cannot_add_codes_auto_generate' => 'Cannot manually add license codes to products set to auto-generate. Change the license code type to "Pick from List" first.',
            'cannot_generate_codes_auto_generate' => 'Cannot manually generate license codes for products set to auto-generate. Change the license code type to "Pick from List" first.',
        ],
        'copied' => 'License code copied to clipboard!',
    ],
    'this_action_will_reload_page' => 'This action will reload the page to update the data!',
    'select' => 'Select',
    'set_this_variant_as_default' => 'Set this variant as default',
    'download' => 'Download',
    'cross_sell_price_type' => [
        'title' => 'Price type',
        'fixed' => 'Fixed',
        'percent' => 'Percent',
    ],
    'cross_sell_help' => [
        'price' => '* Price field',
        'price_description' => 'Enter the amount you want to reduce from the original price. Example: If the original price is $100, enter 20 to reduce the price to $80.',
        'type' => '* Type field',
        'type_description' => 'Choose the discount type: Fixed (reduce a specific amount) or Percent (reduce by a percentage).',
    ],
    'apply_for_all_variations' => 'Apply for all variations',
    'export' => [
        'description' => 'Export your product data to CSV or Excel files.',
        'total_items' => 'Total Items',
        'total_products' => 'Total Products',
        'total_variations' => 'Total Variations',
        'advanced_options' => 'Advanced Options',
        'use_chunked_export' => 'Use chunked export',
        'use_chunked_export_helper' => 'Process data in chunks to handle large datasets efficiently',
        'include_variations' => 'Include product variations',
        'include_variations_helper' => 'Export product variations along with main products',
        'optimize_memory' => 'Optimize memory usage',
        'optimize_memory_helper' => 'Enable memory optimization for very large exports',
        'chunk_size' => 'Chunk size',
        'chunk_size_helper' => 'Number of products to process at a time (50-5000)',
        'use_streaming' => 'Use streaming export',
        'use_streaming_helper' => 'Enable streaming for very large datasets (automatically enabled for >10,000 items)',
        'large_dataset_warning_title' => 'Large Product Catalog Detected',
        'large_dataset_warning_message' => 'Your catalog contains :count items. Due to the large size, some export options have been optimized for best performance.',
        'large_dataset_specific_message' => 'For your :count products, use CSV format with streaming enabled. The system can now handle your large product catalog efficiently without timeouts or memory issues.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (Required)',
        'chunk_label' => 'Processing',
        'chunk_recommended' => '300 products/batch',
        'time_label' => 'Estimated Time',
        'time_estimate' => '1-3 minutes',
        'pro_tip' => 'Pro Tip:',
        'pro_tip_message' => 'The export will continue running even if your browser shows a loading indicator. Once started, the download will begin automatically.',
        'large_dataset_tip_1' => 'Excel format has been disabled - use CSV format for faster and more reliable exports',
        'large_dataset_tip_2' => 'Streaming mode has been automatically enabled to prevent timeouts',
        'large_dataset_tip_3' => 'Export process may take 1-3 minutes depending on your server',
        'large_dataset_recommendation' => 'Recommended: Use CSV format with 200-500 chunk size for optimal performance.',
        'excel_disabled_for_large_export' => 'Excel format not available for catalogs over 10,000 items',
        'streaming_auto_enabled' => 'Streaming mode has been automatically enabled for optimal performance with large datasets.',
        'streaming_enabled_title' => 'Optimized for Large Export',
        'streaming_enabled_message' => 'Streaming mode is active to ensure smooth export without memory issues.',
        'recommended_range' => 'Recommended range',
        'range_large_export' => '200-500 items',
        'range_medium_export' => '300-800 items',
        'range_small_export' => '500-1000 items',
        'export_progress' => 'Export Progress',
        'preparing_export' => 'Preparing export...',
        'items_processed' => ':count items processed',
        'estimated_time_calculating' => 'Estimated time: calculating...',
        'medium_dataset_detected' => 'Medium Dataset Detected',
        'medium_dataset_message' => 'You\'re exporting :count products. Consider using chunked export for better performance.',
        'optimal_range' => 'Optimal range',
        'too_small_slow' => 'Too small - may be slow',
        'too_large_timeouts' => 'Too large - may cause timeouts',
        'excel_disabled_warning' => 'Excel format disabled for large exports (:count items)',
        'starting_export' => 'Starting Export...',
        'processing_data' => 'Processing data...',
        'finalizing_export' => 'Finalizing export...',
        'items_processed_suffix' => 'items processed',
        'estimated_time_prefix' => 'Estimated time:',
        'seconds_remaining' => 's remaining',
        'export_completed' => 'Export completed!',
        'download_starting' => 'Download starting...',
    ],
    'import' => [
        'description' => 'Import your product data from CSV or Excel files.',
        'rules' => [
            'in' => ':attribute must be one of defined values: :values.',
            'required_string_max' => ':attribute is required and must be a string with a maximum length of :max characters.',
            'nullable_string' => ':attribute can be left empty or must be a string if provided.',
            'nullable_string_max' => ':attribute can be left empty or must be a string with a maximum length of :max characters if provided',
            'nullable_bool' => 'Whether :attribute can be left empty or must be a boolean value if provided.',
            'nullable_numeric_min' => ':attribute can be left empty or must be a non-negative number if provided.',
            'nullable_numeric_min_max' => ':attribute can be leave blank or must be a number between :min and :max if provided.',
            'nullable_array' => ':attribute can be left empty or must be provided as an array if specified.',
            'nullable_date_required_if' => ':attribute can be left empty or must be a valid date if provided, required if :required is specified.',
            'nullable_date_after' => ':attribute can be left empty or must be a valid date after the :after if provided.',
        ],
        'updated_message' => 'Updated :count products successfully!',
    ],
    'import_products_intro' => 'Or import products from CSV/Excel',
    'select_attributes' => 'Select attributes to create variations:',
    'all' => 'All',
    'copy' => 'Copy',
];
